/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.mixin.block;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.block.CustomProperties;
import com.github.mim1q.convenientdecor.init.ModItems;
import com.github.mim1q.convenientdecor.item.WateringCanItem;
import java.util.function.Consumer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HoeItem.class})
public abstract class HoeItemMixin
extends DiggerItem {
    protected HoeItemMixin(float attackDamage, float attackSpeed, Tier material, TagKey<Block> effectiveBlocks, Item.Properties settings) {
        super(attackDamage, attackSpeed, material, effectiveBlocks, settings);
    }

    @Inject(method={"createTillAction"}, at={@At(value="RETURN")}, cancellable=true)
    private static void createTillAction(BlockState result, CallbackInfoReturnable<Consumer<UseOnContext>> cir) {
        if (!ConvenientDecor.CONFIG.features.wateringCanPermanentFarmland) {
            return;
        }
        if (result.m_60713_(Blocks.f_50093_)) {
            cir.setReturnValue(ctx -> {
                int waterLevel;
                ItemStack offhandStack;
                boolean hydrated = false;
                Player player = ctx.m_43723_();
                if (player != null && (offhandStack = player.m_21120_(InteractionHand.OFF_HAND)) != null && offhandStack.m_150930_((Item)ModItems.WATERING_CAN) && (waterLevel = WateringCanItem.getWaterLevel(offhandStack)) > 0) {
                    WateringCanItem.setWaterLevel(offhandStack, waterLevel - 1);
                    hydrated = true;
                }
                ctx.m_43725_().m_7731_(ctx.m_8083_(), (BlockState)((BlockState)result.m_61124_((Property)CustomProperties.HYDRATED, (Comparable)Boolean.valueOf(hydrated))).m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(hydrated ? 7 : 0)), 11);
                ctx.m_43725_().m_220407_(GameEvent.f_157792_, ctx.m_8083_(), GameEvent.Context.m_223719_((Entity)ctx.m_43723_(), (BlockState)result));
            });
        }
    }
}

